<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/FichesBudgetaires"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="FichesBudgetaires"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:16.0pt;
  font-family:"Times New Roman",serif;}
p.Standard, li.Standard, div.Standard
  {
  margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
p.TableContents, li.TableContents, div.TableContents
  {
  margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="50%" valign="top" style="border:none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> - 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="50%" valign="top" style="border:none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Date édition :
                        
                        
                        <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
      </div>
      
      <div class="WordSection1">
         <div align="center">
            <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><xsl:for-each select="$docbudg/Budget/Compte/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DFB_BU_CPT_NumOrdre_0" select="."></xsl:variable><xsl:variable name="blocLignes_DFB_BU_CPT_NumOrdre_0" select="$docbudg/Budget/Compte[(./@NumOrdre=$codeBoucleBloc_DFB_BU_CPT_NumOrdre_0)]"/><xsl:if test="$blocLignes_DFB_BU_CPT_NumOrdre_0"><tr xmlns:odm="http://www.axyus.com/2010/odm" class="PAGE_BREAK"><xsl:variable name="varOdm1" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="100%" colspan="8" style="padding: 0cm 0cm 0cm 0cm" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif"><span style="color:black">Fiche Budgétaire du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DFB_BU_CPT_NumOrdre_0/@DateDebut)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template>au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DFB_BU_CPT_NumOrdre_0/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></span></b></p><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif;color:black">du compte <xsl:value-of select="distinct-values($blocLignes_DFB_BU_CPT_NumOrdre_0/@NumCompte)"/>- <xsl:value-of select="distinct-values($blocLignes_DFB_BU_CPT_NumOrdre_0/@IntituleCompte)"/></span></b></p></td></tr><xsl:choose><xsl:when test="$docbudg/Budget/Compte/@CodeRD = R and $docbudg/Budget/Compte/@Section= I"><xsl:variable name="varOdm2" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB/LigneFB"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="100%" colspan="8" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Section Investissement Recette</span></p>
                  </td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="100%" colspan="8" rowspan="1" style="padding: 0cm 0cm 0cm 0cm"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/Budget/Compte/@CodeRD = R and $docbudg/Budget/Compte/@Section= F"><xsl:variable name="varOdm3" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB/LigneFB"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="100%" colspan="8" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Section Fonctionnement Recette</span></p>
                  </td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="100%" colspan="8" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/Budget/Compte/@CodeRD = D and $docbudg/Budget/Compte/@Section= I"><xsl:variable name="varOdm4" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB/LigneFB"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="100%" colspan="8" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Section Investissement Dépense</span></p>
                  </td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="100%" colspan="8" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/Budget/Compte/@CodeRD = D and $docbudg/Budget/Compte/@Section= F"><xsl:variable name="varOdm5" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB/LigneFB"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="100%" colspan="8" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"> Section Fonctionnement Dépense</span></p>
                  </td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="100%" colspan="8" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="49.9%" colspan="4" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DFB_BU_CPT_NumOrdre_0)]/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DFB_BU_CPT_NumOrdre_0)]/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="50.1%" colspan="4" style="padding: 0cm .5pt 1.5pt .5pt;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice :<xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DFB_BU_CPT_NumOrdre_0)]/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm" class="LIGNE"><xsl:variable name="varOdm6" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="100%" colspan="8" style="border:none;border-bottom: solid black 1.0pt;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                     <p class="TableContents"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"></span></p>
                  </td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:25.5pt"><td width="17%" style="border-top:none;border-left:solid black 1.0pt; border-bottom:solid black 1.0pt;border-right:none;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:25.5pt" rowspan="1" colspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date de la PEC</span></b></p>
                  </td><td width="14.8%" style="border-top:none;border-left:solid black 1.0pt; border-bottom:solid black 1.0pt;border-right:none;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:25.5pt" rowspan="1" colspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Référence de la pièce</span></b></p>
                  </td><td width="15.1%" style="border-top:none;border-left:solid black 1.0pt; border-bottom:solid black 1.0pt;border-right:none;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:25.5pt" rowspan="1" colspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date de solde de la pièce</span></b></p>
                  </td><td width="13.3%" colspan="2" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:25.5pt" rowspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant des émissions</span></b></p>
                  </td><td width="13.3%" style="border-top:none;border-left:solid black 1.0pt; border-bottom:solid black 1.0pt;border-right:none;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:25.5pt" rowspan="1" colspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant des annulations</span></b></p>
                  </td><td width="13.2%" style="border-top:none;border-left:solid black 1.0pt; border-bottom:solid black 1.0pt;border-right:none;padding: 0cm .5pt 1.5pt .5pt; height:25.5pt" rowspan="1" colspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Type Op. (O/R)</span></b></p>
                  </td><td width="13.3%" style="border:solid black 1.0pt;border-top:none; padding: 0cm .5pt 1.5pt .5pt;height:25.5pt" rowspan="1" colspan="1">
                     <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Observations</span></b></p>
                  </td></tr><xsl:for-each select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DFB_BU_CPT_PFB_NumOrdre_0" select="."></xsl:variable><xsl:variable name="blocLignes_DFB_BU_CPT_PFB_NumOrdre_0" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB[(./@NumOrdre=$codeBoucleBloc_DFB_BU_CPT_PFB_NumOrdre_0)]"/><xsl:if test="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0"><tr xmlns:odm="http://www.axyus.com/2010/odm" class="VIDE"><xsl:variable name="varOdm7" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="17%" style="border:none;border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt" rowspan="1" colspan="1">
                     <p class="TableContents" style="layout-grid-mode:char"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black;background:#23FF23"></span></p>
                  </td><td width="14.8%" style="border:none;border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt" rowspan="1" colspan="1"> </td><td width="15.1%" style="border:none;border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt" rowspan="1" colspan="1"> </td><td width="13.3%" colspan="2" style="border:none;border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt" rowspan="1"> </td><td width="13.3%" style="border:none;border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt" rowspan="1" colspan="1"> </td><td width="13.2%" style="border:none;border-bottom:solid black 1.0pt; padding:0cm .5pt 0cm .5pt" rowspan="1" colspan="1"> </td><td width="13.3%" style="border:none;border-bottom:solid black 1.0pt; padding:0cm .5pt 0cm .5pt" rowspan="1" colspan="1"> </td></tr><xsl:variable name="varOdm8" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/LigneFB"/><xsl:variable name="varOdm9"><xsl:for-each select="$varOdm8"><xsl:sort select="./@NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="content24"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DatePEC)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className66" select="$ligne/@Format"/><xsl:variable name="className67">LIBELLE</xsl:variable><xsl:variable name="className68">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className66, ' ', $className67, ' ', $className68)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">17%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content24" /></xsl:call-template><xsl:variable name="content25"><xsl:value-of select="distinct-values($ligne/@ReferencePiece)"/></xsl:variable><xsl:variable name="className69" select="$ligne/@Format"/><xsl:variable name="className70">LIBELLE</xsl:variable><xsl:variable name="className71">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className69, ' ', $className70, ' ', $className71)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">14.8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content25" /></xsl:call-template><xsl:variable name="content26"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DateSolde)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className72" select="$ligne/@Format"/><xsl:variable name="className73">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className72, ' ', $className73)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content26" /></xsl:call-template><xsl:variable name="content27"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MtEmissions"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className74" select="$ligne/@Format"/><xsl:variable name="className75">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className74, ' ', $className75)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content27" /></xsl:call-template><xsl:variable name="content28"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MtAnnulations"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className76" select="$ligne/@Format"/><xsl:variable name="className77">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className76, ' ', $className77)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content28" /></xsl:call-template><xsl:variable name="content29"><xsl:value-of select="distinct-values($ligne/@TypeOpe)"/></xsl:variable><xsl:variable name="className78" select="$ligne/@Format"/><xsl:variable name="className79">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className78, ' ', $className79)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content29" /></xsl:call-template><xsl:variable name="content30"><xsl:value-of select="distinct-values($ligne/@Observations)"/></xsl:variable><xsl:variable name="className80" select="$ligne/@Format"/><xsl:variable name="className81">LIBELLE</xsl:variable><xsl:variable name="className82">VBORDER</xsl:variable><xsl:variable name="className83">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className80, ' ', $className81, ' ', $className82, ' ', $className83)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content30" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm10"><xsl:choose><xsl:when test="count($varOdm9/*) = 0"><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="17%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt; border-top:hidden; border-left:none; border-right:none"></td><td height="1px" width="14.8%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt; border-top:hidden; border-left:none; border-right:none"></td><td height="1px" width="15.1%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt; border-top:hidden; border-left:none; border-right:none"></td><td height="1px" width="13.3%" colspan="2" rowspan="1" style="border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt; border-top:hidden; border-left:none; border-right:none"></td><td height="1px" width="13.3%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding:1.4pt 1.4pt 0cm 1.4pt; border-top:hidden; border-left:none; border-right:none"></td><td height="1px" width="13.2%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding:0cm .5pt 0cm .5pt; border-top:hidden; border-left:none; border-right:none"></td><td height="1px" width="13.3%" rowspan="1" colspan="1" style="border-bottom:solid black 1.0pt; padding:0cm .5pt 0cm .5pt; border-top:hidden; border-left:none; border-right:none"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm9"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm10/xhtml:tr"></xsl:with-param></xsl:call-template><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:42.5pt"><xsl:variable name="varOdm11" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/LigneFB"/><xsl:variable name="content31"> </xsl:variable><xsl:variable name="className84" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className85">LIBELLE</xsl:variable><xsl:variable name="className86">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className84, ' ', $className85, ' ', $className86)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">17%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content31" /></xsl:call-template><xsl:variable name="content32"><xsl:value-of select="distinct-values($blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Libelle)"/></xsl:variable><xsl:variable name="className87" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className88">LIBELLE</xsl:variable><xsl:variable name="className89">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className87, ' ', $className88, ' ', $className89)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">14.8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content32" /></xsl:call-template><xsl:variable name="content33"> </xsl:variable><xsl:variable name="className90" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className91">LIBELLE</xsl:variable><xsl:variable name="className92">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className90, ' ', $className91, ' ', $className92)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content33" /></xsl:call-template><xsl:variable name="content34"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@MtEmissions"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className93" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className94">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className93, ' ', $className94)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content34" /></xsl:call-template><xsl:variable name="content35"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@MtAnnulations"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className95" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className96">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className95, ' ', $className96)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content35" /></xsl:call-template><xsl:variable name="content36"> </xsl:variable><xsl:variable name="className97" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className98">LIBELLE</xsl:variable><xsl:variable name="className99">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className97, ' ', $className98, ' ', $className99)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content36" /></xsl:call-template><xsl:variable name="content37">
                     <span></span>
                  </xsl:variable><xsl:variable name="className100" select="$blocLignes_DFB_BU_CPT_PFB_NumOrdre_0/TotalPiece/@Format"/><xsl:variable name="className101">LIBELLE</xsl:variable><xsl:variable name="className102">VBORDER</xsl:variable><xsl:variable name="className103">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className100, ' ', $className101, ' ', $className102, ' ', $className103)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content37" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:42.5pt"><xsl:variable name="varOdm12" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/PieceFB/LigneFB"/><xsl:variable name="content38"><xsl:value-of select="distinct-values($blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Libelle)"/>  <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DFB_BU_CPT_NumOrdre_0/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className104" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Format"/><xsl:variable name="className105">LIBELLE</xsl:variable><xsl:variable name="className106">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className104, ' ', $className105, ' ', $className106)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">31.8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content38" /></xsl:call-template><xsl:variable name="content39"> </xsl:variable><xsl:variable name="className107" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Format"/><xsl:variable name="className108">LIBELLE</xsl:variable><xsl:variable name="className109">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className107, ' ', $className108, ' ', $className109)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content39" /></xsl:call-template><xsl:variable name="content40"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@MtEmissions"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className110" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Format"/><xsl:variable name="className111">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className110, ' ', $className111)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content40" /></xsl:call-template><xsl:variable name="content41"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@MtAnnulations"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className112" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Format"/><xsl:variable name="className113">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className112, ' ', $className113)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content41" /></xsl:call-template><xsl:variable name="content42"> </xsl:variable><xsl:variable name="className114" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Format"/><xsl:variable name="className115">LIBELLE</xsl:variable><xsl:variable name="className116">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className114, ' ', $className115, ' ', $className116)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content42" /></xsl:call-template><xsl:variable name="content43">
                     <span></span>
                  </xsl:variable><xsl:variable name="className117" select="$blocLignes_DFB_BU_CPT_NumOrdre_0/TotalCompte/@Format"/><xsl:variable name="className118">LIBELLE</xsl:variable><xsl:variable name="className119">VBORDER</xsl:variable><xsl:variable name="className120">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className117, ' ', $className118, ' ', $className119, ' ', $className120)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">13.3%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content43" /></xsl:call-template></tr></xsl:if></xsl:for-each></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         </div>
         <p class="MsoNormal"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>